﻿using System;
using System.Linq;

namespace Spectral1.BUSINESS_LOGIC
{
    public class BL_Spectral
    {
        static public UInt16 LogFnPercTo32766(float perc)
        {
            return (UInt16)((Math.Pow(10, (perc / 50)) - 1) * (661.96 / 2));
        }

        static public UInt16 bounded_uint16(Double i)
        {
            if (i < 0) { return 0; }
            else if (i > 65535) { return 65535; }
            else { return ((UInt16)i); }
        }

        static public Int16 bounded_int16(Double value)
        {
            Int16 result_value;

            if (value > 32767) { result_value = 32767; }
            else if (value < -32767) { result_value = -32767; }
            else { result_value = (Int16)value; }

            return result_value;
        }

        static public Double bounded_usp0to100(Double i)
        {
            if (i < 0) { return 0; }
            else if (i > 100) { return 100; }
            else { return (i); }
        }

        static public Double bounded_sp0to100(Double i)
        {
            if (i < -100) { return -100; }
            else if (i > 100) { return 100; }
            else { return (i); }
        }

        static public Double bounded_usp0to200(Double i)
        {
            if (i < 0) { return 0; }
            else if (i > 200) { return 200; }
            else { return (i); }
        }
        static public string GetNewGuid8()
        {
            Guid g = Guid.NewGuid();
            string gs = g.ToString();
            return gs.Substring(0, 8);
        }

        static public Int32 calc_band_freq(Int32 band_id)
        {
            if (band_id == 0) { return 16; }
            Double band_freq = 16;
            double factor = Math.Pow(2.0, (1.0 / 3.0));

            for (Int32 b = 1; b <= band_id; b++)
            {
                band_freq = band_freq * factor;
            }

            return (Int32)(band_freq); //NOTE : THIS ROUNDS TO NEAREST
        }

        static public bool IsNumeric(string value)
        {
            return value.All(char.IsNumber);
        }
    }
}
